<?php
/*
Plugin Name: WhatsApp Button for WooCommerce by SSWebservices
Plugin URI: https://sswebservices.pt
Description: Substitui ou complementa o botão "Adicionar ao carrinho" por um botão do WhatsApp com configurações avançadas.
Version: 2.2.3
Author: SSWebservices
Author URI: https://sswebservices.pt
License: GPLv2 or later
Text Domain: ssweb-whatsapp-button
*/

if ( ! defined( 'ABSPATH' ) ) exit;

add_action('admin_menu', 'ssweb_add_admin_menu');
add_action('admin_init', 'ssweb_register_settings');

function ssweb_add_admin_menu() {
    add_menu_page(
        'WhatsApp Button',
        'WhatsApp Button',
        'manage_options',
        'ssweb-whatsapp-settings',
        'ssweb_settings_page',
        'dashicons-format-chat',
        100
    );
}

function ssweb_register_settings() {
    register_setting('ssweb_settings_group', 'ssweb_settings', 'ssweb_sanitize');
}

function ssweb_sanitize($input) {
    $output = array();
    foreach ($input as $key => $value) {
        if (strpos($key, 'disable_cart') !== false) {
            $output[$key] = !empty($value) ? 1 : 0;
        } else {
            $output[$key] = sanitize_text_field($value);
        }
    }
    return $output;
}

function ssweb_settings_page() {
    $opt = get_option('ssweb_settings', array());
    ?>
    <div class="wrap">
        <h1>
            <a href="https://sswebservices.pt" target="_blank" style="text-decoration:none; display:flex; align-items:center;">
                <img src="<?php echo plugin_dir_url(__FILE__); ?>assets/ssweb-logo.png" alt="SSWebservices" style="height:40px; margin-right:20px;">
                WhatsApp Button for WooCommerce
            </a>
        </h1>
        <form method="post" action="options.php">
            <?php settings_fields('ssweb_settings_group'); ?>
            <h2>Página do Produto</h2>
            <table class="form-table">
                <tr><th>Número WhatsApp</th>
                    <td><input type="text" name="ssweb_settings[product_number]" value="<?php echo esc_attr($opt['product_number'] ?? ''); ?>" /></td></tr>
                <tr><th>Mensagem Padrão</th>
                    <td><input type="text" name="ssweb_settings[product_message]" value="<?php echo esc_attr($opt['product_message'] ?? 'Olá, gostaria de saber mais sobre {product_name}'); ?>" /></td></tr>
                <tr><th>Texto do Botão</th>
                    <td><input type="text" name="ssweb_settings[product_text]" value="<?php echo esc_attr($opt['product_text'] ?? 'Encomendar via WhatsApp'); ?>" /></td></tr>
                <tr><th>Cor de Fundo</th>
                    <td><input type="text" name="ssweb_settings[product_bg]" value="<?php echo esc_attr($opt['product_bg'] ?? '#25d366'); ?>" /></td></tr>
                <tr><th>Cor do Texto</th>
                    <td><input type="text" name="ssweb_settings[product_color]" value="<?php echo esc_attr($opt['product_color'] ?? '#ffffff'); ?>" /></td></tr>
                <tr><th>Cor Hover</th>
                    <td><input type="text" name="ssweb_settings[product_hover]" value="<?php echo esc_attr($opt['product_hover'] ?? '#128c7e'); ?>" /></td></tr>
                <tr><th>Substituir Carrinho?</th>
                    <td><input type="checkbox" name="ssweb_settings[product_disable_cart]" value="1" <?php checked(1, $opt['product_disable_cart'] ?? 0); ?> /></td></tr>
            </table>
            <h2>Página da Loja</h2>
            <table class="form-table">
                <tr><th>Número WhatsApp</th>
                    <td><input type="text" name="ssweb_settings[shop_number]" value="<?php echo esc_attr($opt['shop_number'] ?? ''); ?>" /></td></tr>
                <tr><th>Mensagem Padrão</th>
                    <td><input type="text" name="ssweb_settings[shop_message]" value="<?php echo esc_attr($opt['shop_message'] ?? 'Olá, gostaria de saber mais sobre {product_name}'); ?>" /></td></tr>
                <tr><th>Texto do Botão</th>
                    <td><input type="text" name="ssweb_settings[shop_text]" value="<?php echo esc_attr($opt['shop_text'] ?? 'Encomendar'); ?>" /></td></tr>
                <tr><th>Cor de Fundo</th>
                    <td><input type="text" name="ssweb_settings[shop_bg]" value="<?php echo esc_attr($opt['shop_bg'] ?? '#25d366'); ?>" /></td></tr>
                <tr><th>Cor do Texto</th>
                    <td><input type="text" name="ssweb_settings[shop_color]" value="<?php echo esc_attr($opt['shop_color'] ?? '#ffffff'); ?>" /></td></tr>
                <tr><th>Cor Hover</th>
                    <td><input type="text" name="ssweb_settings[shop_hover]" value="<?php echo esc_attr($opt['shop_hover'] ?? '#128c7e'); ?>" /></td></tr>
                <tr><th>Substituir Carrinho?</th>
                    <td><input type="checkbox" name="ssweb_settings[shop_disable_cart]" value="1" <?php checked(1, $opt['shop_disable_cart'] ?? 0); ?> /></td></tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// Remove cart buttons early including related
add_action('wp', 'ssweb_conditional_remove_cart_buttons');
function ssweb_conditional_remove_cart_buttons() {
    $opt = get_option('ssweb_settings', []);
    if (is_product() && !empty($opt['product_disable_cart'])) {
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
        remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
    }
    if ((is_shop()||is_product_category()||is_product_tag()) && !empty($opt['shop_disable_cart'])) {
        remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
    }
}

// Render buttons
add_action('woocommerce_single_product_summary', 'ssweb_render_product_button', 31);
function ssweb_render_product_button() {
    $opt = get_option('ssweb_settings', []);
    if (!empty($opt['product_number'])) {
        $msg = str_replace('{product_name}', get_the_title(), $opt['product_message']);
        echo "<a href='https://wa.me/".esc_attr($opt['product_number'])."?text=".rawurlencode($msg)."' class='button ssweb-btn' style='background:".esc_attr($opt['product_bg']).";color:".esc_attr($opt['product_color']).";margin-top:10px;'>".esc_html($opt['product_text'])."</a>";
    }
}

add_action('woocommerce_after_shop_loop_item', 'ssweb_render_shop_button', 11);
function ssweb_render_shop_button() {
    $opt = get_option('ssweb_settings', []);
    if (!empty($opt['shop_number'])) {
        $msg = str_replace('{product_name}', get_the_title(), $opt['shop_message']);
        echo "<a href='https://wa.me/".esc_attr($opt['shop_number'])."?text=".rawurlencode($msg)."' class='button ssweb-btn' style='background:".esc_attr($opt['shop_bg']).";color:".esc_attr($opt['shop_color']).";margin-top:10px;'>".esc_html($opt['shop_text'])."</a>";
    }
}

// Hover style
add_action('wp_head', function(){
    $opt = get_option('ssweb_settings', []);
    $hover = esc_attr($opt['product_hover'] ?? $opt['shop_hover'] ?? '#128c7e');
    echo "<style>.ssweb-btn:hover{background:{$hover}!important;}</style>";
});
?>